from tools.utils import read_json
from nltk.corpus import wordnet as wn


class IBPCandidates:
    def __init__(self, supported_postag, p_synonym):
        self.supported_postag = supported_postag
        self.word2synonyms = self.init_candidates(p_synonym)

    def candidate_set(self, token, tag):
        token = token.lower()
        if tag not in self.supported_postag or token == 'be' or token not in self.word2synonyms:
            return []
        return self.word2synonyms[token]

    def init_candidates(self, p_synonym):
        word2synonyms = read_json(p_synonym)
        return word2synonyms


class WordNetCandidate():
    def __init__(self, supported_postag):
        self.supported_pos_tags = supported_postag

    def candidate_set(self, token, tag):
        if tag not in self.supported_pos_tags or token == 'be':
            return []
        tag = self._get_wordnet_tag(tag)

        synonyms = set()
        for syn in wn.synsets(token, pos=tag):
            for name in syn.lemma_names():
                # name = name.lower()
                if '_' in name:
                    # name = name.replace('_', ' ')
                    continue
                if name == token:
                    continue
                if name.lower() == token.lower():
                    continue
                synonyms.add(name)
        synonyms = list(synonyms)
        return synonyms

    def _get_wordnet_tag(self, tag):
        '''Wordnet POS tag'''
        tag = tag.lower()[0]
        if tag in ['r', 'n', 'v']:  # adv, noun, verb
            return tag
        elif tag == 'j':
            return 'a'  # adj
        else:
            return None
